/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import panther.util.general.ErrorUtils;
import panther.util.resource.CallableStatementComponent;
import panther.util.resource.DatabaseMetaDataComponent;
import panther.util.resource.PreparedStatementComponent;
import panther.util.resource.Resource;
import panther.util.resource.ResourcePool;
import panther.util.resource.ResourceThing;
import panther.util.resource.StatementComponent;

class ConnectionResource
extends Resource
implements Connection {
    protected String simpleSQL;
    private static final String UNSUPPORTED_MESSAGE = "This operation will not be supported until all of UNICON's developers are using JDK 1.4.0";

    ConnectionResource(ResourcePool resourcePool, String string, Object object, Object object2, String string2) {
        super(resourcePool, string, object, object2);
        this.simpleSQL = string2;
    }

    protected Connection connection() {
        return (Connection)this.rawResource;
    }

    protected String getRawResourceName() {
        return "Connection";
    }

    protected String getTypeName() {
        return "ConnectionResource";
    }

    public synchronized void copyFrom(Resource resource) {
        super.copyFrom(resource);
        ConnectionResource connectionResource = (ConnectionResource)resource;
        this.simpleSQL = connectionResource.simpleSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean verify() throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection().createStatement();
            if (this.simpleSQL != null && this.simpleSQL.length() > 0) {
                resultSet = statement.executeQuery(this.simpleSQL);
                resultSet.next();
            }
        }
        catch (Exception exception) {
            ErrorUtils.checkSwallow(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        this.lastUseTime = System.currentTimeMillis();
        return true;
    }

    synchronized void refresh() throws Exception {
        if (!this.verify()) {
            throw new Exception("Raw Resource cannot be refreshed");
        }
    }

    synchronized void recycle() throws Exception {
        super.recycle();
        this.connection().rollback();
    }

    synchronized void destroy() throws Exception {
        super.destroy();
        if (this.connection() != null) {
            this.connection().close();
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        this.checkActive();
        Statement statement = this.connection().createStatement();
        statement = new StatementComponent((ResourceThing)this, statement);
        return statement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkActive();
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement = new PreparedStatementComponent((ResourceThing)this, preparedStatement);
        return preparedStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkActive();
        CallableStatement callableStatement = this.connection().prepareCall(string);
        callableStatement = new CallableStatementComponent((ResourceThing)this, callableStatement);
        return callableStatement;
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        this.checkActive();
        return this.connection().nativeSQL(string);
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkActive();
        this.connection().setAutoCommit(bl);
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkActive();
        return this.connection().getAutoCommit();
    }

    public synchronized void close() throws SQLException {
        this.checkActive();
        this.pool.release(this);
    }

    public synchronized void commit() throws SQLException {
        this.checkActive();
        this.connection().commit();
    }

    public synchronized void rollback() throws SQLException {
        this.checkActive();
        this.connection().rollback();
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized boolean isClosed() throws SQLException {
        this.checkActive();
        return this.connection().isClosed();
    }

    public synchronized int getHoldability() throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized void setHoldability(int n) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkActive();
        DatabaseMetaData databaseMetaData = this.connection().getMetaData();
        databaseMetaData = new DatabaseMetaDataComponent((ResourceThing)this, databaseMetaData);
        return databaseMetaData;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkActive();
        this.connection().setReadOnly(bl);
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.checkActive();
        return this.connection().isReadOnly();
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.checkActive();
        this.connection().setCatalog(string);
    }

    public synchronized String getCatalog() throws SQLException {
        this.checkActive();
        return this.connection().getCatalog();
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkActive();
        this.connection().setTransactionIsolation(n);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkActive();
        return this.connection().getTransactionIsolation();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkActive();
        return this.connection().getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkActive();
        this.connection().clearWarnings();
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkActive();
        Statement statement = this.connection().createStatement(n, n2);
        statement = new StatementComponent((ResourceThing)this, statement);
        return statement;
    }

    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkActive();
        PreparedStatement preparedStatement = this.connection().prepareStatement(string, n, n2);
        preparedStatement = new PreparedStatementComponent((ResourceThing)this, preparedStatement);
        return preparedStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkActive();
        CallableStatement callableStatement = this.connection().prepareCall(string, n, n2);
        callableStatement = new CallableStatementComponent((ResourceThing)this, callableStatement);
        return callableStatement;
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.checkActive();
        return this.connection().getTypeMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.checkActive();
        this.connection().setTypeMap(map);
    }
}

